/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.core;

import com.mrcrayfish.furniture.inventory.container.CrateContainer;
import com.mrcrayfish.furniture.inventory.container.FreezerContainer;
import com.mrcrayfish.furniture.inventory.container.MailBoxContainer;
import com.mrcrayfish.furniture.inventory.container.PostBoxContainer;
import com.mrcrayfish.furniture.tileentity.CrateTileEntity;
import com.mrcrayfish.furniture.tileentity.FreezerTileEntity;
import com.mrcrayfish.furniture.tileentity.MailBoxTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="cfm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModContainers {
    private static final List<ContainerType<?>> CONTAINER_TYPES = new ArrayList();
    public static final ContainerType<CrateContainer> CRATE = ModContainers.register("cfm:crate", (windowId, playerInventory, data) -> {
        CrateTileEntity crateTileEntity = (CrateTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        return new CrateContainer(windowId, playerInventory, crateTileEntity, crateTileEntity.isLocked());
    });
    public static final ContainerType<PostBoxContainer> POST_BOX = ModContainers.register("cfm:post_box", PostBoxContainer::new);
    public static final ContainerType<MailBoxContainer> MAIL_BOX = ModContainers.register("cfm:mail_box", (windowId, playerInventory, data) -> {
        MailBoxTileEntity mailBoxTileEntity = (MailBoxTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        return new MailBoxContainer(windowId, playerInventory, mailBoxTileEntity);
    });
    public static final ContainerType<FreezerContainer> FREEZER = ModContainers.register("cfm:freezer", (windowId, playerInventory, data) -> {
        FreezerTileEntity freezerTileEntity = (FreezerTileEntity)playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        return new FreezerContainer(windowId, playerInventory, freezerTileEntity);
    });

    private static <T extends Container> ContainerType<T> register(String key, ContainerType.IFactory<T> factory) {
        ContainerType type = new ContainerType(factory);
        type.setRegistryName(key);
        CONTAINER_TYPES.add(type);
        return type;
    }

    @SubscribeEvent
    public static void registerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        CONTAINER_TYPES.forEach(type -> event.getRegistry().register((IForgeRegistryEntry)type));
        CONTAINER_TYPES.clear();
    }
}

